<?php

/**
 * TCB Javascript translations
 */

// phpcs:disable
return array(
	'success'                            => __( 'Success', 'thrive-cb' ),
	'error'                              => __( 'Error', 'thrive-cb' ),
	'signup_success'                     => __( 'Sign up successful', 'thrive-cb' ),
	'login_success'                      => __( 'Successfully logged in', 'thrive-cb' ),
	'tweet_too_long'                     => __( 'Tweet text is too long', 'thrive-cb' ),
	'post_too_long'                      => __( 'Post text is too long', 'thrive-cb' ),
	'share'                              => __( 'Share', 'thrive-cb' ),
	'fb_app_id_required'                 => __( 'Facebook App ID is required', 'thrive-cb' ),
	'validating_app_id'                  => __( 'Validating...', 'thrive-cb' ),
	'fb_app_id_valid'                    => __( 'App ID validated', 'thrive-cb' ),
	'fb_app_id_invalid'                  => __( 'Invalid App ID', 'thrive-cb' ),
	'column_layout'                      => __( 'Select Columns Layout', 'thrive-cb' ),
	'video_background'                   => __( 'Video background', 'thrive-cb' ),
	'video_lazy_load'                    => __( 'Lazy loading', 'thrive-cb' ),
	'video_cover'                        => __( 'Video cover / thumbnail', 'thrive-cb' ),
	'video_reporting_toggle'             => __( 'Record video events', 'thrive-cb' ),
	'video_completion_rate'              => __( 'Consider video completed at', 'thrive-cb' ),
	'saving'                             => __( 'Saving...', 'thrive-cb' ),
	'image'                              => __( 'Image', 'thrive-cb' ),
	'name'                               => __( 'Name', 'thrive-cb' ),
	'phone'                              => __( 'Phone', 'thrive-cb' ),
	'opacity'                            => __( 'Opacity', 'thrive-cb' ),
	'blur'                               => __( 'Blur', 'thrive-cb' ),
	'greyscale'                          => __( 'Greyscale', 'thrive-cb' ),
	'brightness'                         => __( 'Brightness', 'thrive-cb' ),
	'contrast'                           => __( 'Contrast', 'thrive-cb' ),
	'sepia'                              => __( 'Sepia', 'thrive-cb' ),
	'invert'                             => __( 'Invert', 'thrive-cb' ),
	'saturate'                           => __( 'Saturate', 'thrive-cb' ),
	'huerotate'                          => __( 'Hue Rotate', 'thrive-cb' ),
	'pattern'                            => __( 'Pattern', 'thrive-cb' ),
	'Add_Layer'                          => __( 'Add layer', 'thrive-cb' ),
	'AddNew'                             => __( 'Add new', 'thrive-cb' ),
	'Text'                               => __( 'Text', 'thrive-cb' ),
	'TextShadow'                         => __( 'Text Shadow', 'thrive-cb' ),
	'InnerShadow'                        => __( 'Inner Shadow', 'thrive-cb' ),
	'DropShadow'                         => __( 'Drop Shadow', 'thrive-cb' ),
	'solid_color'                        => __( 'Solid color', 'thrive-cb' ),
	'background_effects'                 => __( 'Background Effects', 'thrive-cb' ),
	'gradient'                           => __( 'Gradient', 'thrive-cb' ),
	'lin_grad'                           => __( 'Linear gradient', 'thrive-cb' ),
	'rep_lin_grad'                       => __( 'Repeating linear gradient', 'thrive-cb' ),
	'rad_grad'                           => __( 'Radial gradient', 'thrive-cb' ),
	'rep_rad_grad'                       => __( 'Repeating radial gradient', 'thrive-cb' ),
	'Color'                              => __( 'Color', 'thrive-cb' ),
	'Link'                               => __( 'Link', 'thrive-cb' ),
	'Selected'                           => __( 'Selected', 'thrive-cb' ),
	'missing_invalid_url'                => __( 'URL is missing or invalid', 'thrive-cb' ),
	'required_video'                     => __( 'Please choose a video', 'thrive-cb' ),
	'required_audio'                     => __( 'Please choose an audio track', 'thrive-cb' ),
	'ChooseImage'                        => __( 'Choose image', 'thrive-cb' ),
	'ChooseFile'                         => __( 'Choose File', 'thrive-cb' ),
	'ChooseVideo'                        => __( 'Choose video', 'thrive-cb' ),
	'ChooseAudio'                        => __( 'Choose audio', 'thrive-cb' ),
	'Files'                              => __( 'Files', 'thrive-cb' ),
	'Videos'                             => __( 'Videos', 'thrive-cb' ),
	'Audios'                             => __( 'Audios', 'thrive-cb' ),
	'Desktop'                            => __( 'Desktop', 'thrive-cb' ),
	'Tablet'                             => __( 'Tablet', 'thrive-cb' ),
	'Mobile'                             => __( 'Mobile', 'thrive-cb' ),
	'Visible'                            => __( 'Visible', 'thrive-cb' ),
	'Hidden'                             => __( 'Hidden', 'thrive-cb' ),
	'Disabled'                           => __( 'Disabled', 'thrive-cb' ),
	'ID'                                 => __( 'ID', 'thrive-cb' ),
	'Class'                              => __( 'Class', 'thrive-cb' ),
	'tpl_name_required'                  => __( 'Template name is blank. Please choose a name for your template.', 'thrive-cb' ),
	'RedirectionUrlInvalid'              => __( 'The redirection will not take place because the URL you\'ve entered is not valid!', 'thrive-cb' ),
	'slanted_edge'                       => __( 'Slanted Edge', 'thrive-cb' ),
	'pointer'                            => __( 'Pointer', 'thrive-cb' ),
	'divider'                            => __( 'Divider', 'thrive-cb' ),
	'UrlInvalid'                         => __( 'The URL you\'ve entered is not valid!', 'thrive-cb' ),
	'ProgressBarLabel'                   => __( 'Progress Bar', 'thrive-cb' ),
	'OnlyThreeHeadingsSelected'          => __( 'Only three headings can be selected at once !', 'thrive-cb' ),
	'variation_required'                 => __( 'At least one text variation is required', 'thrive-cb' ),
	'default_text_required'              => __( 'Default text is required', 'thrive-cb' ),
	'none'                               => __( 'None', 'thrive-cb' ),
	'TemplateRevert'                     => __( 'Template reverted to theme successfully!', 'thrive-cb' ),
	'PageTemplateSave'                   => __( 'Page template successfully saved!', 'thrive-cb' ),
	'TemplateChange'                     => __( 'Template changed successfully!', 'thrive-cb' ),
	'TemplateSave'                       => __( 'Template saved successfully!', 'thrive-cb' ),
	'anim'                               => array(
		'player_color'           => __( 'Player color', 'thrive-cb' ),
		'evt_replaced'           => __( 'Another identical configuration exists for this trigger. It has been replaced with the new one', 'thrive-cb' ),
		'multiple_click_events'  => __( 'You have multiple events that are triggered on click. Please remove one.', 'thrive-cb' ),
		'missing'                => __( 'Please select an animation', 'thrive-cb' ),
		'img_missing'            => __( 'Please select an image', 'thrive-cb' ),
		'lb_missing'             => __( 'Please select a lightbox', 'thrive-cb' ),
		'vs_missing'             => __( 'You have to select a video source', 'thrive-cb' ),
		'vu_invalid'             => __( 'Could not validate the video URL', 'thrive-cb' ),
		'video_format_err'       => __( 'Video format from the provided URL is not supported. Please try again', 'thrive-cb' ),
		'video_id_err'           => __( 'Cannot get the video ID from the provided URL. Please try again', 'thrive-cb' ),
		'video_info_err'         => __( 'Could not get video information. Please check the URL and try again.', 'thrive-cb' ),
		'video_info_priv'        => __( 'This video is private. Some information may not be available.', 'thrive-cb' ),
		'wistia_info_warn'       => __( "Could not get video information from Wistia. It's possible that the embed will still work", 'thrive-cb' ),
		'tooltip_miss'           => __( 'Tooltip text is required', 'thrive-cb' ),
		'url_miss'               => __( 'URL is missing', 'thrive-cb' ),
		'video_voo_success'      => __( 'VooPlayer video was added successfully', 'thrive-cb' ),
		'video_bunnynet_success' => __( 'Bunny.net Stream video was added successfully', 'thrive-cb' ),
		'defaultAspectLabel'     => __( 'Default aspect ratio (16:9)', 'thrive-cb' ),
		'floatingVideo'          => __( 'Sticky float on scroll', 'thrive-cb' ),
		'closeFloat'             => __( 'Enable Close Button', 'thrive-cb' ),
		'previewFloat'           => __( 'View Floating Video in Preview', 'thrive-cb' ),
		'previewFloatLabel'      => __( 'Floating Video Preview', 'thrive-cb' ),
	),
	'error_labels'                       => array(
		'email'                => __( 'Email error', 'thrive-cb' ),
		'phone'                => __( 'Phone number error', 'thrive-cb' ),
		'password'             => __( 'Password error', 'thrive-cb' ),
		'passwordmismatch'     => __( 'Password mismatch error', 'thrive-cb' ),
		'required'             => __( 'Required field error', 'thrive-cb' ),
		'file_size'            => __( 'Uploaded file too large', 'thrive-cb' ),
		'file_extension'       => __( 'Uploaded file type not allowed', 'thrive-cb' ),
		'max_files'            => __( 'Maximum number of uploaded files exceeded', 'thrive-cb' ),
		'required_field'       => __( 'Required field not filled in', 'thrive-cb' ),
		'recaptcha'            => __( 'Recaptcha validation fail', 'thrive-cb' ),
		'file_required'        => __( 'Required file error', 'thrive-cb' ),
		'upload_progress'      => __( 'While the upload is in progress', 'thrive-cb' ),
		'password_score'       => __( 'Weak password', 'thrive-cb' ),
		'link_invalid'         => __( 'Invalid youtube link', 'thrive-cb' ),
		'youtube_link_invalid' => __( 'Invalid external link', 'thrive-cb' ),
	),
	'lg_errors'                          => array(
		'email'                => __( 'Email address invalid', 'thrive-cb' ),
		'phone'                => __( 'Phone number invalid', 'thrive-cb' ),
		'password'             => __( 'Password invalid', 'thrive-cb' ),
		'passwordmismatch'     => __( 'Password mismatch', 'thrive-cb' ),
		'required'             => __( 'Required field missing', 'thrive-cb' ),
		'required_field'       => __( 'This field is required', 'thrive-cb' ),
		'file_required'        => __( 'At least one file is required', 'thrive-cb' ),
		'file_size'            => __( '{file} exceeds the maximum file size of {filelimit}', 'thrive-cb' ),
		'max_files'            => __( 'Sorry, the maximum number of files is {maxfiles}', 'thrive-cb' ),
		'link_invalid'         => __( 'Sorry, that URL is not valid', 'thrive-cb' ),
		'youtube_link_invalid' => __( 'Sorry, that URL is not a valid youtube video link', 'thrive-cb' ),
		'file_extension'       => __( 'Sorry, {fileextension} files are not allowed', 'thrive-cb' ),
		'upload_progress'      => __( 'File upload in progress. Please wait for the upload to finish and try again.', 'thrive-cb' ),
		'recaptcha'            => __( 'We are detecting suspicious activity from your device. Please try in another browser or contact the website administrator.', 'thrive-cb' ),
		'password_score'       => __( 'Please choose a stronger password. Try including numbers, symbols, and a mix of upper and lowercase letters and remove common words.', 'thrive-cb' ),
	),
	'cf_errors'                          => array(
		'empty_fields'         => array(
			'label' => __( 'Some fields are empty!', 'thrive-cb' ),
		),
		'passwords_not_match'  => array(
			'label' => __( 'The passwords do not match', 'thrive-cb' ),
		),
		'email'                => array(
			'label' => __( 'Email error', 'thrive-cb' ),
			'text'  => __( 'Email address invalid', 'thrive-cb' ),
		),
		'phone'                => array(
			'label' => __( 'Phone number error', 'thrive-cb' ),
			'text'  => __( 'Phone number invalid', 'thrive-cb' ),
		),
		'url'                  => array(
			'label'   => __( 'URL error', 'thrive-cb' ),
			'text'    => __( 'URL invalid', 'thrive-cb' ),
			'empty'   => __( 'Please enter the URL where visitors will be redirected to after they submit the form', 'thrive-cb' ),
			'invalid' => __( 'Invalid URL', 'thrive-cb' ),
		),
		'required'             => array(
			'label' => __( 'Required field error', 'thrive-cb' ),
			'text'  => __( 'Required field empty', 'thrive-cb' ),
		),
		'to'                   => array(
			'empty'   => __( 'You have to set to which email address(es) the contact form should be sent', 'thrive-cb' ),
			'invalid' => __( 'To email field is invalid. Please check the emil address(es) are correct', 'thrive-cb' ),
		),
		'subject'              => array(
			'empty' => __( 'Please enter the subject for the email that will be sent to you when the form will be sent', 'thrive-cb' ),
		),
		'cc'                   => array(
			'invalid' => __( 'CC email field is invalid. Please check the emil address(es) are correct', 'thrive-cb' ),
		),
		'bcc'                  => array(
			'invalid' => __( 'BCC email field is invalid. Please check the emil address(es) are correct', 'thrive-cb' ),
		),
		'action'               => array(
			'empty' => __( 'Please select an action to be performed after the form will be submitted', 'thrive-cb' ),
		),
		'confirmation_message' => array(
			'empty' => __( 'Please fill in the confirmation message', 'thrive-cb' ),
		),
		'confirmation_subject' => array(
			'empty' => __( 'Please fill in the subject for confirmation email', 'thrive-cb' ),
		),
		'from_name'            => array(
			'empty' => __( 'Please fill in the from name', 'thrive-cb' ),
		),
		'from_email'           => array(
			'empty'   => __( 'Please fill in From Email', 'thrive-cb' ),
			'invalid' => __( 'From Email is not a valid email address', 'thrive-cb' ),
		),
		'reply_to'             => array(
			'invalid' => __( 'Invalid email address for reply to', 'thrive-cb' ),
		),
		'notification'         => array(
			'empty' => __( 'Please fill in notification text', 'thrive-cb' ),
		),
	),
	'cf_defaults'                        => array(
		'email_subject'        => __( 'New message from: ', 'thrive-cb' ),
		'submit_title'         => __( 'After submit action', 'thrive-cb' ),
		'notification'         => __( 'Your message has been sent, thank you!', 'thrive-cb' ),
		'confirmation_email'   => __( "Hello, \n\nThanks for contacting us. We'll get back to you as soon as possible with the information you need. \n\nBest regards,\n[wp_site_title]", 'thrive-cb' ),
		'confirmation_subject' => __( 'Contact Form submission confirmation', 'thrive-cb' ),
	),
	'table_sorting_disabled'             => __( 'This table has merged cells. It cannot be sorted', 'thrive-cb' ),
	'delete_template'                    => __( 'Delete content template', 'thrive-cb' ),
	'confirm_delete_tpl'                 => __( 'Are you sure you want to remove this Content Template? This action cannot be undone', 'thrive-cb' ),
	'cancel'                             => __( 'Cancel', 'thrive-cb' ),
	'create_new_lightbox'                => __( 'Create new lightbox', 'thrive-cb' ),
	'ChangeDirection'                    => __( 'Change direction', 'thrive-cb' ),
	'Invert'                             => __( 'Invert', 'thrive-cb' ),
	'pinterest_img_required'             => __( 'Image is required for pinterest share', 'thrive-cb' ),
	'EditHTML'                           => __( 'Edit HTML Form', 'thrive-cb' ),
	'ConnectForm'                        => __( 'Connect Form To Service', 'thrive-cb' ),
	'SignUp'                             => __( 'Sign Up', 'thrive-cb' ),
	'ReloadPage'                         => __( 'Reload Page', 'thrive-cb' ),
	'RedirectURL'                        => __( 'Redirect to Custom URL', 'thrive-cb' ),
	'NoRedirect'                         => __( 'No Redirect', 'thrive-cb' ),
	'SuccessNotification'                => __( 'Show success notification', 'thrive-cb' ),
	'NextStepInQuiz'                     => __( 'Go to next step in quiz', 'thrive-cb' ),
	'InvalidHTML'                        => __( 'Invalid code! Please add at least one input.', 'thrive-cb' ),
	'ApiConnected'                       => __( 'API successfully added!', 'thrive-cb' ),
	'apiChoose'                          => __( 'Choose connection', 'thrive-cb' ),
	'NoConnections'                      => __( 'You have no active connections.', 'thrive-cb' ),
	'DeleteContentInLandingPage'         => __( "Are you sure you want to DELETE all of the content that was created in this landing page and revert to the theme page?\nIf you click OK, any custom content you added to the landing page will be deleted.", 'thrive-cb' ),
	'ClearContentOfLandingPage'          => __( 'Are you sure you want to CLEAR all content from this Landing Page? This action cannot be undone', 'thrive-cb' ),
	'ExportFileNameRequired'             => __( 'Template name is required', 'thrive-cb' ),
	'EnterTemplateName'                  => __( 'Please enter a template name, it will be easier to reload it after.', 'thrive-cb' ),
	'SelectTemplate'                     => __( 'First, you must select a template from the available ones.', 'thrive-cb' ),
	'UnknownError'                       => __( 'An unknown error has occured. Response was: ', 'thrive-cb' ),
	'LPImportConfirm'                    => __( 'Importing a landing page will overwrite the current contents of this page. Are you sure you want to continue ?', 'thrive-cb' ),
	'LeavePageUnsavedChanges'            => __( 'If you leave this page then any unsaved changes will be lost', 'thrive-cb' ),
	'AllChangesSaved'                    => __( 'All changes saved!', 'thrive-cb' ),
	'emptyContent'                       => __( 'The content is empty. Please input some content.', 'thrive-cb' ),
	'page_event_action_duplicate'        => __( 'An event is already setup for this Trigger and Action. Please choose another configuration.', 'thrive-cb' ),
	'Custom_URL'                         => __( 'Custom URL', 'thrive-cb' ),
	'EditImageCaption'                   => __( 'Edit your caption text here', 'thrive-cb' ),
	'Max_Width'                          => __( 'Max width', 'thrive-cb' ),
	'Float'                              => __( 'Float', 'thrive-cb' ),
	'Position'                           => __( 'Position', 'thrive-cb' ),
	'Overflow'                           => __( 'Overflow', 'thrive-cb' ),
	'ScrollStyle'                        => __( 'Style scrollbar', 'thrive-cb' ),
	'Zindex'                             => __( 'Z-index', 'thrive-cb' ),
	'Edit_Components'                    => __( 'Edit Components', 'thrive-cb' ),
	'LinkState'                          => __( 'State:', 'thrive-cb' ),
	'State_Default'                      => __( 'Default', 'thrive-cb' ),
	'State_Hover'                        => __( 'Hover', 'thrive-cb' ),
	'State_Visited'                      => __( 'Visited', 'thrive-cb' ),
	//	'fav_color_add'                      => __( 'Add current color to favorites', 'thrive-cb' ),
	'animation_disabled'                 => __( 'Animations applied here are available on all screen sizes. In order to edit these, switch to Desktop Preview.', 'thrive-cb' ),
	'klicktipp_thank_you_url'            => __( 'KlickTipp Thank You URL', 'thrive-cb' ),
	'unknownError'                       => __( 'An unknown error occured.', 'thrive-cb' ),
	'ChooseLandingPageTemplate'          => __( 'Choose Landing Page Template', 'thrive-cb' ),
	'ChangeLandingPageTemplate'          => __( 'Change Landing Page Template', 'thrive-cb' ),
	'WrapColumnsOnTablet'                => __( 'Wrap columns on tablet', 'thrive-cb' ),
	'WrapColumnsOnMobile'                => __( 'Wrap columns on mobile', 'thrive-cb' ),
	'EditLightBox'                       => __( 'Edit Lightbox', 'thrive-cb' ),
	'EditThriveBox'                      => __( 'Edit Thrivebox', 'thrive-cb' ),
	'FetchingData'                       => __( 'Fetching data...', 'thrive-cb' ),
	'Element'                            => __( 'Element', 'thrive-cb' ),
	'reminderz_off'                      => __( 'Turn Off Save Reminders ', 'thrive-cb' ),
	'reminderz_on'                       => __( 'Turn On Save Reminders ', 'thrive-cb' ),
	'warning_link_inside_link'           => __( 'You cannot have nested links inside containers. Please remove the link of the ##split## in order to drop the new element', 'thrive-cb' ),
	'warning_link_insert_inside_link'    => __( 'You cannot have nested links inside containers. Please remove the link of the ##split## in order to insert new link', 'thrive-cb' ),
	'warning_link_pasted_inside_link'    => __( 'You cannot have nested links inside containers. Pasted text contains links. Try to remove the link of the', 'thrive-cb' ),
	'prevent_nested_links'               => __( 'You cannot have nested links inside containers. Remove the links inside this element in order to insert new link', 'thrive-cb' ),
	'elements'                           => array(
		'user_profile'       => __( 'User Profile', 'thrive-cb' ),
		'progressbar'        => __( 'Progress Bar', 'thrive-cb' ),
		'countdown'          => __( 'Countdown', 'thrive-cb' ),
		'testimonial'        => __( 'Testimonial', 'thrive-cb' ),
		'menu'               => __( 'Menu', 'thrive-cb' ),
		'table'              => __( 'Table', 'thrive-cb' ),
		'toc'                => __( 'Table of Contents', 'thrive-cb' ),
		'pricing_table'      => __( 'Pricing Table', 'thrive-cb' ),
		'stylebox'           => __( 'Styled Box', 'thrive-cb' ),
		'callaction'         => __( 'Call to Action', 'thrive-cb' ),
		'guaranteebox'       => __( 'Guarantee Box', 'thrive-cb' ),
		'contact_form'       => __( 'Contact Form', 'thrive-cb' ),
		'checkout'           => __( 'Checkout', 'thrive-cb' ),
		'fancydivider'       => __( 'Fancy divider', 'thrive-cb' ),
		'post_list'          => __( 'Post List', 'thrive-cb' ),
		'pagination'         => __( 'Pagination', 'thrive-cb' ),
		'shop'               => __( 'Shop', 'thrive-cb' ),
		'toggle'             => __( 'Toggle', 'thrive-cb' ),
		'tabs'               => __( 'Tabs', 'thrive-cb' ),
		'search_form'        => __( 'Search Form', 'thrive-cb' ),
		'login'              => esc_html__( 'Login & Registration Form', 'thrive-cb' ),
		'post_list_featured' => __( 'Featured Content List', 'thrive-cb' ),
		'form'               => __( 'Form', 'thrive-cb' ),
	),
	'el_dir_top'                         => __( 'Above', 'thrive-cb' ),
	'el_dir_bottom'                      => __( 'Below', 'thrive-cb' ),
	'el_dir_left'                        => __( 'Left of', 'thrive-cb' ),
	'el_dir_right'                       => __( 'Right of', 'thrive-cb' ),
	'el_dir_mid'                         => __( 'Inside', 'thrive-cb' ),
	'symbol_could_not_be_saved'          => __( 'The symbol could not be saved', 'thrive-cb' ),
	'symbol_cannot_save_in_hover'        => __( 'The symbol cannot be saved while you are in hover state!', 'thrive-cb' ),
	'header_cannot_save_in_hover'        => __( 'The header cannot be saved while you are in hover state!', 'thrive-cb' ),
	'footer_cannot_save_in_hover'        => __( 'The footer cannot be saved while you are in hover state!', 'thrive-cb' ),
	'symbol_cannot_save_in_lg_edit_mode' => __( 'The symbol cannot be saved while you are in lead generation edit state!', 'thrive-cb' ),
	'header_cannot_save_in_lg_edit_mode' => __( 'The header cannot be saved while you are in lead generation edit state!', 'thrive-cb' ),
	'footer_cannot_save_in_lg_edit_mode' => __( 'The footer cannot be saved while you are in lead generation edit state!', 'thrive-cb' ),
	'symbol_saved'                       => __( 'The Symbol was saved successfully', 'thrive-cb' ),
	'header_saved'                       => __( 'The Header was saved successfully', 'thrive-cb' ),
	'footer_saved'                       => __( 'The Footer was saved successfully', 'thrive-cb' ),
	'header_already_in_page'             => __( 'You already have a Header in the page. Scroll up to the top of the page to see it.', 'thrive-cb' ),
	'footer_already_in_page'             => __( 'You already have a Footer in the page. Scroll down to the bottom of the page to see it.', 'thrive-cb' ),
	'template_placeholder'               => __( 'Enter Template Name', 'thrive-cb' ),
	'symbol_placeholder'                 => __( 'Enter Symbol Name', 'thrive-cb' ),
	'template_label'                     => __( 'Template Name', 'thrive-cb' ),
	'symbol_label'                       => __( 'Symbol Name', 'thrive-cb' ),
	'symbol_button'                      => __( 'Save New Symbol', 'thrive-cb' ),
	'template_button'                    => __( 'Save New Template', 'thrive-cb' ),
	'update_template_button'             => __( 'Update Existing Template', 'thrive-cb' ),
	'template_description'               => __( 'Saved Templates can be easily loaded into your pages. Updating a template will not affect any live content.', 'thrive-cb' ),
	'show_templates_description'         => __( ' results. Check "Show all Saved Templates"', 'thrive-cb' ),
	'template_search_label'              => __( 'Type a name to search for existing templates or to create a new one', 'thrive-cb' ),
	'symbol_input_label'                 => __( 'Type a name to create a new Symbol', 'thrive-cb' ),
	'symbol_description'                 => __( 'Saved Symbols can be loaded across your website. Changes you make will be reflected everywhere the symbol is displayed.', 'thrive-cb' ),
	'select_category'                    => __( 'Select Category...', 'thrive-cb' ),
	'add_as_category'                    => __( 'Add as Category', 'thrive-cb' ),
	'symbol_name_required'               => __( 'Symbol name is blank. Please choose a name for your symbol.', 'thrive-cb' ),
	'header_name_required'               => __( "The header's name is required", 'thrive-cb' ),
	'footer_name_required'               => __( "The footer's name is required", 'thrive-cb' ),
	'element_for_thumb_is_missing'       => __( 'The element for generating the thumb is missing', 'thrive-cb' ),
	'error_image_source'                 => __( 'Something went wrong when getting image source', 'thrive-cb' ),
	'thumb_file_not_saved'               => __( "The thumb for the content wasn't save", 'thrive-cb' ),
	'category_created'                   => __( 'The Category was successfully created!', 'thrive-cb' ),
	'warning_symbol_inside'              => __( "All the symbols inside this element will be automatically unlinked. It's not possible to save a symbol or a template that contain another symbol.", 'thrive-cb' ),
	'warning_symbol_inside_lp'           => __( "Symbols will be unlinked in your export file so that their content won't be lost when importing on another site.", 'thrive-cb' ),
	'warning_conditional_inside'         => __( 'This page contains multiple state elements with conditional display logic. Please be aware that if you import this content on another site the elements will not be rendered.', 'thrive-cb' ),
	'import_empty_content'               => __( 'The imported content is empty. The archive might be corrupted.', 'thrive-cb' ),
	'search_elem'                        => __( 'Search', 'thrive-cb' ),
	'choose_elem'                        => __( 'Choose', 'thrive-cb' ),
	'warning_change_ct'                  => __( 'If you change your %s template, you will lose all the content that you have added to your existing %s!', 'thrive-cb' ),
	'add_template_to_cat'                => __( 'Add template to category', 'thrive-cb' ),
	'add_symbol_to_cat'                  => __( 'Add symbol to category', 'thrive-cb' ),
	'insert_hf'                          => __( 'Insert', 'thrive-cb' ),
	'choose_hf'                          => __( 'Choose', 'thrive-cb' ),
	'floating_relative'                  => __( 'Auto position cannot be used when floating is enabled', 'thrive-cb' ),
	'add_header_tooltip'                 => __( 'You already have a Header in the page. Scroll up to the top of the page to see it.', 'thrive-cb' ),
	'add_footer_tooltip'                 => __( 'You already have a Footer in the page. Scroll down to the bottom of the page to see it.', 'thrive-cb' ),
	'save_close'                         => __( 'Save & Close ', 'thrive-cb' ),
	'Icon'                               => __( 'Icon', 'thrive-cb' ),
	'Font'                               => __( 'Font', 'thrive-cb' ),
	'scroll'                             => array(
		'Static'          => __( 'Static', 'thrive-cb' ),
		'Sticky'          => __( 'Sticky', 'thrive-cb' ),
		'distanceTop'     => __( 'Distance from the top of the screen', 'thrive-cb' ),
		'top'             => __( 'Top', 'thrive-cb' ),
		'bottom'          => __( 'Bottom', 'thrive-cb' ),
		'distanceBottom'  => __( 'Distance from the bottom of the screen', 'thrive-cb' ),
		'EndOfPage'       => __( 'End of page', 'thrive-cb' ),
		'Parent'          => __( 'End of parent container', 'thrive-cb' ),
		'Element'         => __( 'It reaches another element', 'thrive-cb' ),
		'Appear'          => __( 'Appear on Scroll Up', 'thrive-cb' ),
		'Parallax'        => __( 'Parallax', 'thrive-cb' ),
		'horizontal'      => __( 'Horizontal Scroll', 'thrive-cb' ),
		'vertical'        => __( 'Vertical Scroll', 'thrive-cb' ),
		'transparency'    => __( 'Transparency ', 'thrive-cb' ),
		'blur'            => __( 'Blur', 'thrive-cb' ),
		'rotate'          => __( 'Rotate', 'thrive-cb' ),
		'3dperspective'   => __( '3D Perspective', 'thrive-cb' ),
		'scale'           => __( 'Scale', 'thrive-cb' ),
		'up'              => __( 'Up', 'thrive-cb' ),
		'left'            => __( 'Left', 'thrive-cb' ),
		'right'           => __( 'Right', 'thrive-cb' ),
		'down'            => __( 'Down', 'thrive-cb' ),
		'scaleUp'         => __( 'Scale Up', 'thrive-cb' ),
		'scaleUpDown'     => __( 'Scale Up Down', 'thrive-cb' ),
		'scaleDown'       => __( 'Scale Down', 'thrive-cb' ),
		'scaleDownUp'     => __( 'Scale Down Up', 'thrive-cb' ),
		'fadeIn'          => __( 'Fade In', 'thrive-cb' ),
		'fadeOut'         => __( 'Fade Out', 'thrive-cb' ),
		'fadeInOut'       => __( 'Fade In Out ', 'thrive-cb' ),
		'fadeOutIn'       => __( 'Fade Out In', 'thrive-cb' ),
		'fromPerspective' => __( 'From Perspective', 'thrive-cb' ),
		'toPerspective'   => __( 'To Perspective', 'thrive-cb' ),
		'speed'           => __( 'Speed', 'thrive-cb' ),
		'level'           => __( 'Level', 'thrive-cb' ),
		'preview'         => __( 'Parallax preview mode active', 'thrive-cb' ),
	),
	'default_templates'                  => __( 'Default Templates', 'thrive-cb' ),
	'cloud_templates'                    => __( 'Cloud Templates', 'thrive-cb' ),
	'thrive_templates'                   => __( 'Thrive Templates', 'thrive-cb' ),
	'style_name'                         => __( 'Style Name', 'thrive-cb' ),
	'inherit_lp_font'                    => __( 'Inherit Landing Page Font', 'thrive-cb' ),
	'inherit_theme_font'                 => __( 'Inherit Theme Font', 'thrive-cb' ),
	'inherit'                            => __( 'Inherit', 'thrive-cb' ),
	'placeholder_text'                   => __( 'Click to add text or drag and drop element from right hand panel', 'thrive-cb' ),
	'dropdown_placeholder'               => __( 'Please Select One', 'thrive-cb' ),
	'global'                             => array(
		'element_not_found'      => __( 'There aren\'t any instances on this page. You can add it by drag and drop.', 'thrive-cb' ),
		'global_styles'          => __( 'Global Styles', 'thrive-cb' ),
		'template_styles'        => __( 'Template Styles', 'thrive-cb' ),
		'global_color_edit'      => __( 'Careful, you are editing a global color.', 'thrive-cb' ),
		'template_color_edit'    => __( 'Careful, you are editing a template color.', 'thrive-cb' ),
		'global_gradient_edit'   => __( 'Careful, you are editing a global gradient.', 'thrive-cb' ),
		'template_gradient_edit' => __( 'Careful, you are editing a template gradient.', 'thrive-cb' ),
		'delete_confirmation'    => __( 'By deleting the global style, all the elements using it will be reset to their default styles. Are you sure you want to proceed?', 'thrive-cb' ),
		'no_styles_created'      => __( 'You have no Global Styles created', 'thrive-cb' ),
		'style_name_required'    => __( 'You need to define a name to your global style!', 'thrive-cb' ),
		'element_style'          => __( 'Save Global %s Style', 'thrive-cb' ),
		'edit_mode_label'        => __( 'Editing Global Style', 'thrive-cb' ),
		'tooltip_instance'       => __( 'This can only be changed at the Global Style level', 'thrive-cb' ),
		'tooltip_global'         => __( 'This cannot be changed at the Global Style level', 'thrive-cb' ),
		'update_color'           => __( 'Update global color', 'thrive-cb' ),
		'update_t_color'         => __( 'Update template color', 'thrive-cb' ),
		'update_gradient'        => __( 'Update global gradient', 'thrive-cb' ),
		'update_t_gradient'      => __( 'Update template gradient', 'thrive-cb' ),
		'edit_color'             => __( 'Edit global color', 'thrive-cb' ),
		'edit_t_color'           => __( 'Edit template color', 'thrive-cb' ),
		'edit_gradient'          => __( 'Edit global gradient', 'thrive-cb' ),
		'edit_t_gradient'        => __( 'Edit template gradient', 'thrive-cb' ),
		'unlink_color'           => __( 'Unlink global color', 'thrive-cb' ),
		'unlink_t_color'         => __( 'Unlink template color', 'thrive-cb' ),
		'unlink_gradient'        => __( 'Unlink global gradient', 'thrive-cb' ),
		'unlink_t_gradient'      => __( 'Unlink template gradient', 'thrive-cb' ),
		'cancel_update'          => __( 'Cancel changes', 'thrive-cb' ),
		'save_favorite_color'    => __( 'Save as favorite color', 'thrive-cb' ),
		'save_favorite_gradient' => __( 'Save as favorite gradient', 'thrive-cb' ),
		'save_global_color'      => __( 'Save as global color', 'thrive-cb' ),
		'save_global_gradient'   => __( 'Save as global gradient', 'thrive-cb' ),
	),
	'ajax_error'                         => array(
		'wordfence'       => __( 'The action could not be finished because the plugin "WordFence" blocked the request. Set your WordFence Firewall to "Learning Mode" or $1 this action and try again.', 'thrive-cb' ),
		'403'             => __( 'The action could not be finished because it was forbidden.', 'thrive-cb' ),
		'404'             => __( 'The action could not be finished because the URL could not be found.', 'thrive-cb' ),
		'500'             => __( 'The action could not be finished because of a fatal server error.', 'thrive-cb' ),
		'session_expired' => __( 'The action could not be finished because your session expired and you are no longer logged in. Log in using the form below in order to continue.', 'thrive-cb' ),
	),
	'linkType'                           => array(
		'static'  => __( 'Static link', 'thrive-cb' ),
		'jump'    => __( 'Jumplink', 'thrive-cb' ),
		'dynamic' => __( 'Dynamic link', 'thrive-cb' ),
	),
	'jumplink_added'                     => __( 'Jump link successfully added', 'thrive-cb' ),
	'dynamiclink_added'                  => __( 'Dynamic link successfully added', 'thrive-cb' ),
	'cb_link'                            => __( 'Content box link', 'thrive-cb' ),
	'contentBlocks'                      => __( 'Content blocks', 'thrive-cb' ),
	'allBlocks'                          => __( 'All blocks', 'thrive-cb' ),
	'img_link'                           => __( 'Image link', 'thrive-cb' ),
	'btn_link'                           => __( 'Button link', 'thrive-cb' ),
	'link'                               => __( 'Link', 'thrive-cb' ),
	'invalidLink'                        => __( 'The selected item has a link that is invalid or no longer available!', 'thrive-cb' ),
	'invalidVideo'                       => __( 'One or more dynamic videos have an invalid source set. Please update them.', 'thrive-cb' ),
	'logo_link'                          => __( 'Logo link', 'thrive-cb' ),
	'nofollow'                           => __( 'No follow', 'thrive-cb' ),
	'newtab'                             => __( 'Open in new tab', 'thrive-cb' ),
	'redirect_logout'                    => __( 'Redirect after successful logout', 'thrive-cb' ),
	'smooth_anim'                        => __( 'Smooth animation', 'thrive-cb' ),
	'select_target'                      => __( 'Select a target', 'thrive-cb' ),
	'linkSet'                            => __( 'You have a %s link set. Remove it first.', 'thrive-cb' ),
	'post_list_no_author_description'    => __( 'No Author Description', 'thrive-cb' ),
	'multipleApis'                       => __( "You're about to connect more than one API to the form!", 'thrive-cb' ),
	'apiConnectionChanged'               => __( 'API connection setup changed wih success!', 'thrive-cb' ),
	'lgConnectionRemoved'                => __( 'That API connection is not available anymore. Remove it and choose another one.', 'thrive-cb' ),
	'resetStateAction'                   => __( 'State has been reset!', 'thrive-cb' ),
	'lp_default'                         => __( 'Landing Page Default', 'thrive-cb' ),
	'Formatting'                         => __( 'Formatting', 'thrive-cb' ),
	'addTag'                             => __( 'Add a tag...', 'thrive-cb' ),
	'download_media_msg'                 => __( 'Please note that disabling this checkbox will hide the download option from the player, but your media could still be downloaded if a visitor finds the direct file URL.', 'thrive-cb' ),
	'all_categories'                     => __( 'All Categories', 'thrive-cb' ),
	'post_list_query_title'              => __( 'I want to display the following', 'thrive-cb' ),
	'post_list_incompatible_taxonomy'    => __( 'will not be displayed in the results because they are not associated with', 'thrive-cb' ),
	'post_list_offset_disabled'          => __( 'Not available while pagination is enabled', 'thrive-cb' ),
	'featured_list_query_title'          => __( 'I want to Feature the following Content', 'thrive-cb' ),
	'redirect_send_params'               => __( 'Send form values to thank you page', 'thrive-cb' ),
	'lg_err'                             => array(
		'missing_from_name' => __( 'From Name should not be empty', 'thrive-cb' ),
		'missing_to_emails' => __( 'Please add at least one email address', 'thrive-cb' ),
		'invalid_email'     => __( 'Invalid Email', 'thrive-cb' ),
		'invalid_data'      => __( "Some fields aren't properly completed", 'thrive-cb' ),
		'single_reply_to'   => __( 'Only one email is allowed for "Reply To" field', 'thrive-cb' ),
		'single_from_email' => __( 'Only one email is allowed for "From Email" field', 'thrive-cb' ),
		'empty_subject'     => __( 'Be advised that for some email delivery services, the email will not be sent if the subject is empty.', 'thrive-cb' ),
		'empty_message'     => __( 'Be advised that for some email delivery services, the email will not be sent if the message is empty.', 'thrive-cb' ),
		'name_start'        => __( 'Names must begin with a letter.', 'thrive-cb' ),
		'name_char'         => __( 'Names can only include letters, digits, hyphens, underscores, colons and periods.', 'thrive-cb' ),
	),
	'lg_tooltip'                         => __( 'The shortcode [ form_fields ] includes all data submitted by the user in list format', 'thrive-cb' ),
	'placeholder'                        => __( 'Placeholder', 'thrive-cb' ),
	'label'                              => __( 'Label', 'thrive-cb' ),
	'set_as_default'                     => __( 'Set as default', 'thrive-cb' ),
	'ct_symbol_name_changed'             => __( 'The name was changed successfully', 'thrive-cb' ),
	'ct_symbol_deleted'                  => __( 'This was deleted successfully', 'thrive-cb' ),
	'ct_symbol_error'                    => __( 'Something went wrong. Please try again.', 'thrive-cb' ),
	'ct_symbol_missing_new_title'        => __( 'Please enter a new name.', 'thrive-cb' ),
	'save_dash_return'                   => __( 'Save and Return to Post Editor', 'thrive-cb' ),
	'login_states'                       => array(
		'login'                 => __( 'Login Form', 'thrive-cb' ),
		'forgot_password'       => __( 'Password Recovery Form', 'thrive-cb' ),
		'recovery_confirmation' => __( 'Password Recovery Confirmation', 'thrive-cb' ),
		'already_logged_in'     => __( 'Already Logged In', 'thrive-cb' ),
		'registration_form'     => __( 'Registration Form', 'thrive-cb' ),
	),
	'lg_email'                           => array(
		'email_subject'              => __( 'Someone filled out your form', 'thrive-cb' ),
		'email_message'              => __( "Someone filled out your form with the following details: \n\n [all_form_fields]", 'thrive-cb' ),
		'email_confirmation_subject' => __( 'Your submission was received', 'thrive-cb' ),
		'email_confirmation_message' => __( "Hello, \n\nThanks for contacting us. We'll get back to you as soon as possible with the information you need . \n\nBest regards, \n[wp_site_title]", 'thrive-cb' ),
	),
	'color_edit_redirected'              => __( ' colors are inherited from here', 'thrive-cb' ),
	'icons'                              => array(
		'kit_success' => __( 'Font Awesome Pro successfully loaded', 'thrive-cb' ),
		'kit_fail'    => __( 'Invalid Font Awesome Pro kit provided ', 'thrive-cb' ),
	),
	'fields_data'                        => array(
		'set'    => __( 'Dynamic data set successfully', 'thrive-cb' ),
		'remove' => __( 'Dynamic data removed successfully', 'thrive-cb' ),
	),
	'Form'                               => __( 'Form', 'thrive-cb' ),
	'Hover'                              => __( 'Hover', 'thrive-cb' ),
	'Active'                             => __( 'Active', 'thrive-cb' ),
	'Expired'                            => __( 'Expired', 'thrive-cb' ),
	'DragHover'                          => __( 'Drag hover', 'thrive-cb' ),
	'existing_template'                  => __( 'That template name already exists, please use another name', 'thrive-cb' ),
	'fileStorageChoose'                  => __( 'Choose file hosting service', 'thrive-cb' ),
	'applyChanges'                       => __( 'Apply changes', 'thrive-cb' ),
	'changesApplied'                     => __( 'Changes applied', 'thrive-cb' ),
	'evergreen'                          => __( 'Countdown Evergreen', 'thrive-cb' ),
	'missingSocialName'                  => __( 'Social Name is missing or invalid', 'thrive-cb' ),
	'notAvailable'                       => __( 'Not Available', 'thrive-cb' ),
	'user_profile'                       => array(
		'user_email'   => __( 'Email', 'thrive-cb' ),
		'username'     => __( 'Username', 'thrive-cb' ),
		'nickname'     => __( 'Nickname', 'thrive-cb' ),
		'first_name'   => __( 'First name', 'thrive-cb' ),
		'last_name'    => __( 'Last name', 'thrive-cb' ),
		'display_name' => __( 'Display name publicly as', 'thrive-cb' ),
		'website'      => __( 'Website', 'thrive-cb' ),
		'user_bio'     => __( 'Biographical info', 'thrive-cb' ),
		'pass1'        => __( 'New password', 'thrive-cb' ),
		'pass2'        => __( 'Password confirmation', 'thrive-cb' ),
	),
	'reloadingImages'                    => __( 'Reloading thumbnail images', 'thrive-cb' ),
	'resetCarousel'                      => __( 'Reset style to carousel default', 'thrive-cb' ),
	'customizeCarouselDots'              => __( 'Customize dots style', 'thrive-cb' ),
	'customizeCarouselArrows'            => __( 'Customize arrows style', 'thrive-cb' ),
	'logged_in'                          => __( 'Logged in', 'thrive-cb' ),
	'logged_out'                         => __( 'Logged out', 'thrive-cb' ),
	'always'                             => __( 'Always', 'thrive-cb' ),
	'show_when'                          => __( 'Show when', 'thrive-cb' ),
	'notification_states'                => array(
		'notification_success_message' => __( 'Success message!', 'thrive-cb' ),
		'notification_warning_message' => __( 'Warning message!', 'thrive-cb' ),
		'notification_error_message'   => __( 'Error message!', 'thrive-cb' ),
	),
	'ttbLogo'                            => __( 'Thrive Theme Builder logo', 'thrive-cb' ),
	'taLogo'                             => __( 'Thrive Apprentice logo', 'thrive-cb' ),
	'logo'                               => array(
		'renamed'     => __( 'Logo renamed successfully.', 'thrive-cb' ),
		'renameError' => __( 'Error on renaming the logo.', 'thrive-cb' ),
		'invalidName' => __( 'Error - invalid logo name!', 'thrive-cb' ),
		'delConfirm'  => __( 'Are you sure you want to delete this logo?', 'thrive-cb' ),
		'deleted'     => __( 'Logo deleted successfully.', 'thrive-cb' ),
		'deleteError' => __( 'Error on deleting logo.', 'thrive-cb' ),
	),
	'inheritLPTypography'                => __( 'Inherit typography from the active theme', 'thrive-cb' ),

);
// phpcs:enable
